# coding: utf-8
# ===========================================================================
# ★ WF-RGSS Scripts ★
#    Exit-EX 終了処理スクリプト（共通実行スクリプト VXAce版）
# バージョン   ： rev-2.1 (2012-1-24)
# 作者         ： A Crying Minister (WHITE-FLUTE)
# サポート先URI： http://www.whiteflute.org/wfrgss/
# ---------------------------------------------------------------------------
# 機能：
# ・VXAceの終了処理をXP/VX形式(SystemExit送出)に設定します。
# ・VXAceに限り、共通実行スクリプトと同様に使えます。
# ---------------------------------------------------------------------------
# 設置場所     ：Mainセクション(一番最後)に上書き
#                または、Mainセクションの直前
# 必要スクリプト：
# ・共通スクリプト
# 必要DLL
# ・WFExit.dll
# 注意事項：
# ▽ 共通スクリプトが必要です。
#    改造して使用することを推奨しますが、そのまま使ってもOKです。
# ▽ デバッグモードでエラーを記録する場合、
#    現在のユーザで書き込みを行えることが必要になります。
# ▽ スクリプトが実行されます。これ以降のセクションは実行されません。
#==============================================================================
# ◆ Main ( Execute )
#------------------------------------------------------------------------------
# 　各クラスの定義が終わった後、ここから実際の処理が始まります。
#==============================================================================
#module Exit
#  # ---------------------------------------------------------------------------
#  # ◆ カスタマイズポイント セットアップ処理を記述します。
#  # ---------------------------------------------------------------------------
#  def self.setup
#  end
#  # ---------------------------------------------------------------------------
#  # ◆ カスタマイズポイント 解放処理を記述します。
#  # ---------------------------------------------------------------------------
#  def self.dispose
#    DataManager.save_system
#  end
#end
# ---------------------------------------------------------------------------
# ◆ 以下の内容は変更する必要はありません。
# ---------------------------------------------------------------------------

#==============================================================================
# ◆ Exit モジュール
#------------------------------------------------------------------------------
module Exit
	# ---------------------------------------------------------------------------
	# ◆ 処理実行
	# ---------------------------------------------------------------------------
	begin
		@@hook = Win32API.new('System/WFExit','hookExit','v','l')
		@@exit = Win32API.new('System/WFExit','getToExit','v','l')
		@@quit = Win32API.new('System/WFExit','Quit','v','v')
		@@reset = Win32API.new('System/WFExit','getToReset','v','l')
		@@clear = Win32API.new('System/WFExit','clearReset','v','v')
	rescue Exception
		raise if $TEST
		raise( LoadError , "cannot read modules.(WFExit.dll)")
	end
	@@hook.call()
	# ---------------------------------------------------------------------------
	# ◆ 終了を監視する
	# --------------------------------------------------------------------------- 
	def self.toexit
		raise SystemExit.new(0) if @@exit.call() == 1
	end
	# ---------------------------------------------------------------------------
	# ◆ F12リセットを監視する
	# --------------------------------------------------------------------------- 
	def self.toreset
		raise RGSSReset if @duration && @duration <= 0 if @@reset.call() == 1  
		if @duration && @duration > 0
			@duration -= 1
			@@clear.call()
		end
	end
	# ---------------------------------------------------------------------------
	# ◆ 本当の終了処理
	# ---------------------------------------------------------------------------
	def self.quit
		@@quit.call()
	end
	# ---------------------------------------------------------------------------
	# ◆ リセットカウントをクリア
	# ---------------------------------------------------------------------------
	def self.clearreset(wait = false)
		@@clear.call()
		@duration = wait ? 120 : 0
	end
end
# ---------------------------------------------------------------------------
# ◆ 終了監視をセット
# ---------------------------------------------------------------------------
class << Graphics
	alias __wfexit_uodate__ update
	def Graphics.update
		__wfexit_uodate__
		Exit.toexit
		Exit.toreset
	end
end

# ---------------------------------------------------------------------------
# ◆ セットアップをセット
# ---------------------------------------------------------------------------
class << SceneManager
	alias __wfexit_run__ run
	#--------------------------------------------------------------------------
	# ● 実行
	#--------------------------------------------------------------------------
	def SceneManager.run
		Exit.setup
		Exit.clearreset(true)
		__wfexit_run__
	end
end

# ---------------------------------------------------------------------------
# ◆ 処理実行
# ---------------------------------------------------------------------------

begin
	rgss_main { SceneManager.run }
	# 以下、例外処理
rescue BugDetected, InternalBugDetected => errobj
	begin
		MessageBox.fatalerror( errobj )
		raise SystemExit.new(1)
	rescue Hangup
		nil
	end
	
rescue SyntaxError => errobj
	# -------------------------------------------------------------------------
	# ◆ 例外 SyntaxError
	# -------------------------------------------------------------------------
	# この例外はバグかセットアップが適切にされていない状況で無い限り、
	# 補足されることはない
	begin
		raise( BugDetected, 
			"[FATAL] The invalidated exception was detected. \n\n" +
			"Exception:\n#{errobj}")
	rescue BugDetected => errobj
		begin
			MessageBox.fatalerror( errobj )
			raise SystemExit.new(1)
		rescue Hangup
			nil
		end
	end
rescue SystemExit
	# 終了を補足する。エラーメッセージに書き加えない。
rescue Exception => errobj
	# -------------------------------------------------------------------------
	# ◆ 例外処理
	# 特に指定されていない例外を補足します。
	# ※ rev-2 より、Errno::ENOENT もここで補足します。
	# -------------------------------------------------------------------------
	begin
		MessageBox.fatalerror( errobj )
		raise SystemExit.new(1)
	rescue Hangup
		nil
	end
	
ensure
	# -------------------------------------------------------------------------
	# ● 後処理
	# -------------------------------------------------------------------------
	# 後処理を担当します。
	# スクリプト内容によってはここで解放処理が必要になることがあります。
	Exit.dispose
	# ★ ----------------------------------------------------------------------
	Exit.quit # フックを解放する。実行しないと終了しない危険性大
end

exit # Mainセクションが後に控えている時に処理が渡らないようにする
